define([
  "knockout",
  "text!./home.html",
  "components/sensor/sensorViewModel",
  "queryHandlers/sensorReadingsQueryHandler",
  "services/mqttListener",
  "lodash",
  "knockout-postbox"
], function (
  ko,
  homeTemplate, 
  SensorViewModel,
  SensorReadingsQueryHandler,
  MqttListener,
  _
) {

  function HomeViewModel(route) {

    this.sensorsDict = {};
    this.sensors = ko.observableArray();
    this.isRefreshing = ko.observable(false);
    this.queryHandler = new SensorReadingsQueryHandler();

    var mqttListener = new MqttListener();
    mqttListener.init();

    ko.postbox.subscribe("sensorUpdate", _.bind(this.onSensorUpdated, this));
  }

  HomeViewModel.prototype.addSensor = function (key, sensorData) {
    if (!this.sensorsDict[key]) {
      var viewModel = new SensorViewModel(sensorData);
      this.sensorsDict[key] = viewModel;
      this.sensors.push(viewModel);
    }
  }

  HomeViewModel.prototype.updateSensor = function (key, sensorData) {
    var viewModel = this.sensorsDict[key];
    if (viewModel) {
      viewModel.isOccupied(sensorData.isOccupied);
      viewModel.timestamp(sensorData.timestamp);
    }
  }

  HomeViewModel.prototype.onSensorUpdated = function(data){
      var key = data.name;

      if(this.sensorsDict[key]){
        this.updateSensor(key, data);
      } else {
        this.addSensor(key, data);
      }
  }

  HomeViewModel.prototype.refresh = function () {
    this.isRefreshing(true);
    this.queryHandler.handle().then(_.bind(function(data) {
      var sensorsGroupedByName = _.groupBy(data, "name");
      _.each(sensorsGroupedByName, _.bind(function(sensorReadings, key){
          var latestReading = _.orderBy(sensorReadings, "timestamp").pop();

          if(this.sensorsDict[key]){
            this.updateSensor(key, latestReading);
          } else {
            this.addSensor(key, latestReading);
          }

      }, this));
      this.isRefreshing(false);
    }, this));
  }

  return { viewModel: HomeViewModel, template: homeTemplate };
});