define(["app/config", "mqtt", "lodash", "knockout", "knockout-postbox"], function(config, mqtt, _, ko) {

  function MqttListener() {
  }

  MqttListener.prototype.init = function(){
    this.client  = mqtt.connect(config.current.mqtt_server_url);

    console.debug("Mqtt listener connecting to: " + config.current.mqtt_server_url);
    this.client.on('connect', _.bind(function () {
        console.debug("Mqtt listener connected to topic: " + config.current.mqtt_topic);
        this.client.subscribe(config.current.mqtt_topic); 
    }, this));

    this.client.on('message', function (topic, message) {
        // message is Buffer 
        try{
            var messegeBody = JSON.parse(message.toString());
            console.debug("Mqtt message received: " + message.toString());        
            ko.postbox.publish("sensorUpdate", messegeBody);
        }
        catch(e){
            console.error("Failed to parse message into JSON: [" + message.toString() + "]");
        }
        
    });
  };

  MqttListener.prototype.end = function(){
      if(this.client){
          this.client.end();
      }
  };

  return MqttListener;
});