define([
  "knockout",
  "text!./home.html",
  "components/sensor/sensorViewModel",
  "queryHandlers/sensorReadingsQueryHandler",
  "lodash"
], function (
  ko,
  homeTemplate, 
  SensorViewModel,
  SensorReadingsQueryHandler,
  _
) {

  function HomeViewModel(route) {

    this.sensorsDict = {};
    this.sensors = ko.observableArray();
    this.isRefreshing = ko.observable(false);
    this.queryHandler = new SensorReadingsQueryHandler();
  }

  HomeViewModel.prototype.addSensor = function (key, sensorData) {
    if (!this.sensorsDict[key]) {
      var viewModel = new SensorViewModel(sensorData);
      this.sensorsDict[key] = viewModel;
      this.sensors.push(viewModel);
    }
  }

  HomeViewModel.prototype.updateSensor = function (key, sensorData) {
    var viewModel = this.sensorsDict[key];
    if (viewModel) {
      viewModel.isOccupied(sensorData.isOccupied);
      viewModel.timestamp(sensorData.timestamp);
    }
  }

  HomeViewModel.prototype.refresh = function () {
    this.isRefreshing(true);
    this.queryHandler.handle().then(_.bind(function(data) {
      var sensorsGroupedByName = _.groupBy(data, "name");
      _.each(sensorsGroupedByName, _.bind(function(sensorReadings, key){
          var latestReading = _.orderBy(sensorReadings, "timestamp").pop();

          if(this.sensorsDict[key]){
            this.updateSensor(key, latestReading);
          } else {
            this.addSensor(key, latestReading);
          }
      }, this));
      this.isRefreshing(false);
    }, this));
  }

  return { viewModel: HomeViewModel, template: homeTemplate };
});
