﻿using Autofac;
using SoapConsumer.Queries.Handlers;

namespace SoapConsumer.Modules
{
    public class SoapConsumerModule : Module
    {
        protected override void Load(ContainerBuilder builder)
        {
            base.Load(builder);
            RegisterQueryHandlers(builder);
        }

        private void RegisterQueryHandlers(ContainerBuilder builder)
        {
            builder.RegisterType<TestQueryHandler>().AsImplementedInterfaces();
        }
    }
}
