using System;
using System.Linq;
using System.Reflection;
using Autofac;
using Autofac.Configuration;
using Autofac.Extensions.DependencyInjection;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using SoapConsumer.Helpers;

namespace SoapConsumer
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
            Assemblies = AssembliesProvider.GetReferencingAssemblies("SoapConsumer").ToArray();
        }

        public IConfiguration Configuration { get; }

        private Assembly[] Assemblies { get; set; }

        public void ConfigureServices(IServiceCollection services)
        {
            services.AddControllers();
        }

        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }

            app.UseHttpsRedirection();

            app.UseRouting();

            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });
        }

        public void ConfigureContainer(ContainerBuilder builder)
        {
            builder.RegisterAssemblyModules(Assemblies);
            builder.RegisterModule(new ConfigurationModule(Configuration));
        }

        //private void ConfigureAutofacContainer(IServiceCollection services)
        //{
        //    var builder = new ContainerBuilder();
        //    builder.Populate(services);
        //    builder.RegisterAssemblyModules(Assemblies);
        //    builder.RegisterModule(new ConfigurationModule(Configuration));

        //    AutofacContainer = builder.Build();
        //}
    }
}
