﻿using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using SoapConsumer.Infrastructure.CQRS.Queries;
using SoapConsumer.Queries.Data;
using SoapConsumer.Queries.PipeString;

namespace SoapConsumer.Controllers
{
    [Route("Data")]
    public class DataController : Controller
    {
        private readonly IQueryBus _queryBus;

        public DataController(IQueryBus queryBus)
        {
            _queryBus = queryBus;
        }

        [HttpGet("{id}")]
        public async Task<IActionResult> GetData(int id)
        {
            var result = await _queryBus.ExecuteAsync<GetDataQuery, GetDataQueryResult>(new GetDataQuery {Id = id});

            return Ok(result.Data);
        }

        [HttpGet("PipeString")]
        public async Task<IActionResult> PipeString()
        {
            var result = await _queryBus.ExecuteAsync<GetPipeStringQuery, GetPipeStringQueryResult>(new GetPipeStringQuery());

            return Ok(result);
        }
    }
}
