﻿using Autofac;
using SoapConsumer.Queries.Data;
using SoapConsumer.Queries.PipeString;
using SoapConsumer.Soap.Data;
using SoapConsumer.Soap.PipeString;

namespace SoapConsumer.Modules
{
    public class SoapConsumerModule : Module
    {
        protected override void Load(ContainerBuilder builder)
        {
            base.Load(builder);

            RegisterQueryHandlers(builder);
            RegisterTransformers(builder);
        }

        private void RegisterQueryHandlers(ContainerBuilder builder)
        {
            builder.RegisterType<GetDataQueryHandler>().AsImplementedInterfaces();
            builder.RegisterType<GetPipeStringQueryHandler>().AsImplementedInterfaces();
        }

        private void RegisterTransformers(ContainerBuilder builder)
        {
            builder.RegisterType<GetDataTransformer>().AsImplementedInterfaces();
            builder.RegisterType<GetPipeStringTransformer>().AsImplementedInterfaces();
        }
    }
}
