﻿using System.Threading.Tasks;
using SoapConsumer.Infrastructure.CQRS.Queries.Generic;
using SoapConsumer.Infrastructure.Proxy.Abstract;
using SoapConsumer.Soap.Data;

namespace SoapConsumer.Queries.Data
{
    public class GetDataQueryHandler : IHandleQuery<GetDataQuery, GetDataQueryResult>
    {
        private readonly IWebServiceProxy _webServiceProxy;

        public GetDataQueryHandler(IWebServiceProxy webServiceProxy)
        {
            _webServiceProxy = webServiceProxy;
        }

        public async Task<GetDataQueryResult> HandleAsync(GetDataQuery query)
        {
            var result = await _webServiceProxy.ExecuteAsync<GetDataResult, GetData>(new GetData { value = query.Id });

            return new GetDataQueryResult
            {
                Data = result.Value
            };
        }
    }
}
