﻿using System;
using System.Xml;
using SoapConsumer.Infrastructure.Transformers.Abstract;

namespace SoapConsumer.Soap.PipeString
{
    public class GetPipeStringTransformer : ITransformer<GetPipeStringResult>
    {
        public GetPipeStringResult Transform(string responseData)
        {
            if (string.IsNullOrEmpty(responseData))
            {
                throw new Exception(
                    $"Received contractor creation response result is null. Parameter name: {nameof(responseData)}");
            }

            var xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(responseData);

            //dummy serialization :)
            var arr = xmlDocument.GetElementsByTagName("GetPipeStringResult")[0].InnerText.Split('|');

            return new GetPipeStringResult()
            {
                Id = arr[0],
                Name = arr[1],
                Country = arr[2],
                Town = arr[3]
            };
        }
    }
}
