﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using SoapConsumer.Infrastructure.CQRS.Events.Generic;

namespace SoapConsumer.Infrastructure.CQRS.Events
{
    public class EventBus : IEventBus
    {
        private readonly Func<Type, IEnumerable<IHandleEvent>> _handlersFactory;

        public EventBus(Func<Type, IEnumerable<IHandleEvent>> handlersFactory)
        {
            _handlersFactory = handlersFactory;
        }

        public async Task PublishAsync<TEvent>(TEvent @event) where TEvent : IEvent
        {
            var handlers = _handlersFactory(typeof(TEvent)).Cast<IHandleEvent<TEvent>>();

            foreach (IHandleEvent<TEvent> handler in handlers)
            {
                await handler.HandleAsync(@event);
            }
        }
    }
}