﻿using System;
using System.Threading.Tasks;
using SoapConsumer.Infrastructure.CQRS.Events;
using SoapConsumer.Infrastructure.CQRS.Events.Generic;
using SoapConsumer.Infrastructure.CQRS.Queries.Generic;

namespace SoapConsumer.Infrastructure.CQRS.Queries
{
    public class QueryBus : IQueryBus
    {
        private readonly Func<Type, IHandleQuery> _handlersFactory;
        private readonly IEventBus _eventBus;

        public QueryBus(Func<Type, IHandleQuery> handlersFactorycontext, IEventBus eventBus)
        {
            _handlersFactory = handlersFactorycontext;
            _eventBus = eventBus;
        }

        public async Task<TResult> ExecuteAsync<TQuery, TResult>(TQuery query) where TQuery : IQuery<TResult>
        {
            var beforeQueryEvent = new BeforeQueryExecutionEvent<TQuery> { Query = query };
            await _eventBus.PublishAsync(beforeQueryEvent);
            if (beforeQueryEvent.Abort)
            {
                return default;
            }

            var handler = (IHandleQuery<TQuery, TResult>)this._handlersFactory(typeof(TQuery));
            var result = handler != null ? await handler.HandleAsync(query) : default(TResult);

            var afterQueryEvent = new AfterQueryExecutionEvent<TQuery> { Query = query, Result = result };
            await _eventBus.PublishAsync(afterQueryEvent);

            return result;
        }
    }
}