﻿using System.IO;
using System.Xml;
using System.Xml.Serialization;
using SoapConsumer.Infrastructure.Proxy.Builders.Abstract;

namespace SoapConsumer.Infrastructure.Proxy.Builders
{
    public class SoapXmlBuilder : ISoapXmlBuilder
    {
        public string Build<T>(T value, string @namespace)
        {
            var namespaces = new XmlSerializerNamespaces();
            namespaces.Add("", @namespace);
            var serializer = new XmlSerializer(value.GetType(), @namespace);
            var settings = new XmlWriterSettings
            {
                Indent = true,
                OmitXmlDeclaration = true
            };

            using (var stream = new StringWriter())
            {
                using (var writer = XmlWriter.Create(stream, settings))
                {
                    serializer.Serialize(writer, value, namespaces);
                }
                var xmlRoot = $@"<?xml version=""1.0"" encoding=""utf-8""?>
                <soap12:Envelope
                    xmlns:xsi=""http://www.w3.org/2001/XMLSchema-instance""
                    xmlns:xsd=""http://www.w3.org/2001/XMLSchema""
                    xmlns:soap12=""http://www.w3.org/2003/05/soap-envelope"">
                  <soap12:Body>
                    {stream.ToString()}
                  </soap12:Body >
                </soap12:Envelope > ";
                return xmlRoot;
            }
        }
    }
}