﻿using System;
using System.Collections.Generic;
using System.Linq;
using SoapConsumer.Infrastructure.Transformers.Abstract;

namespace SoapConsumer.Infrastructure.Transformers
{
    public class PipelineTransformer : IPipelineTransformer
    {
        private readonly IEnumerable<ITransformer> _transformers;

        public PipelineTransformer(IEnumerable<ITransformer> transformers)
        {
            _transformers = transformers;
        }

        public TModel Transform<TModel>(string input)
        {
            var transformer = _transformers.OfType<ITransformer<TModel>>().FirstOrDefault();

            if (transformer == null)
            {
                throw new InvalidOperationException($"Transformer for {typeof(TModel)} type was not found.");
            }

            return transformer.Transform(input);
        }
    }
}
