﻿using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using SoapConsumer.Infrastructure.CQRS.Queries;
using SoapConsumer.Queries;

namespace SoapConsumer.Controllers
{
    [Route("test")]
    public class TestController : Controller
    {
        private readonly IQueryBus _queryBus;

        public TestController(IQueryBus queryBus)
        {
            _queryBus = queryBus;
        }

        [HttpGet("testaction")]
        public async Task<IActionResult> TestAction()
        {
            var result = await _queryBus.ExecuteAsync<TestQuery, TestQueryResponse>(new TestQuery { Id = 1 });
            return Ok(result.Data);
        }
    }

   
}
