﻿using System.Threading.Tasks;
using SoapConsumer.Infrastructure.CQRS.Queries.Generic;
using SoapConsumer.Infrastructure.Proxy.Abstract;
using SoapConsumer.Soap;

namespace SoapConsumer.Queries.Handlers
{
    public class TestQueryHandler : IHandleQuery<TestQuery, TestQueryResponse>
    {
        private readonly IWebServiceProxy _webServiceProxy;

        public TestQueryHandler(IWebServiceProxy webServiceProxy)
        {
            _webServiceProxy = webServiceProxy;
        }

        public async Task<TestQueryResponse> HandleAsync(TestQuery query)
        {
            var a = await _webServiceProxy.ExecuteAsync<GetResult, GetData>(new GetData { value = 1 });

            return new TestQueryResponse
            {
                Data = "done from response"
            };
        }
    }
}
