﻿using System;
using Microsoft.Extensions.Configuration;

namespace SoapConsumer.Infrastructure.Helpers
{
    public static class ConfigurationSectionExtensions
    {
        public static string GetValue(this IConfigurationSection configurationSection)
        {
            var isValid = !string.IsNullOrEmpty(configurationSection.Value);

            if (!isValid)
            {
                throw new InvalidOperationException($"Value for patch: {configurationSection.Path} in settings does not exist or is empty");
            }

            return configurationSection.Value;
        }
    }
}
