﻿using System.IO;
using System.Xml;
using System.Xml.Serialization;
using SoapConsumer.Infrastructure.Proxy.Builders.Abstract;
namespace SoapConsumer.Infrastructure.Proxy.Builders
{
    public class SoapXmlBuilder : ISoapXmlBuilder
    {
        public string Build<T>(T value, string @namespace)
        {
            var namespaces = new XmlSerializerNamespaces();
            namespaces.Add("tem", @namespace);
            var serializer = new XmlSerializer(value.GetType(), @namespace);
            var settings = new XmlWriterSettings
            {
                Indent = true,
                OmitXmlDeclaration = true
            };
            using (var stream = new StringWriter())
            {
                using (var writer = XmlWriter.Create(stream, settings))
                {
                    serializer.Serialize(writer, value, namespaces);
                }
                var xmlRoot = $@"<soap12:Envelope
                xmlns:soap12=""http://schemas.xmlsoap.org/soap/envelope/""
                xmlns:tem=""http://tempuri.org/"">
                  <soap12:Body>
                    {stream.ToString()}
                  </soap12:Body>
                </soap12:Envelope>";
                return xmlRoot;
            }
        }
    }
}