﻿using System.Threading.Tasks;
using SoapConsumer.Infrastructure.CQRS.Queries.Generic;
using SoapConsumer.Infrastructure.Proxy.Abstract;
using SoapConsumer.Soap.PipeString;

namespace SoapConsumer.Queries.PipeString
{
    public class GetPipeStringQueryHandler : IHandleQuery<GetPipeStringQuery, GetPipeStringQueryResult>
    {
        private readonly IWebServiceProxy _webServiceProxy;

        public GetPipeStringQueryHandler(IWebServiceProxy webServiceProxy)
        {
            _webServiceProxy = webServiceProxy;
        }

        public async Task<GetPipeStringQueryResult> HandleAsync(GetPipeStringQuery query)
        {
            var result = await _webServiceProxy.ExecuteAsync<GetPipeStringResult, GetPipeString>(new GetPipeString());

            return new GetPipeStringQueryResult
            {
                Id = result.Id,
                Country = result.Country,
                Name = result.Name,
                Town = result.Town
            };
        }
    }
}
