﻿using System;
using System.Xml;
using SoapConsumer.Infrastructure.Transformers.Abstract;

namespace SoapConsumer.Soap.Data
{
    public class GetDataTransformer : ITransformer<GetDataResult>
    {
        public GetDataResult Transform(string responseData)
        {
            if (string.IsNullOrEmpty(responseData))
            {
                throw new Exception(
                    $"Received contractor creation response result is null. Parameter name: {nameof(responseData)}");
            }

            var xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(responseData);

            return new GetDataResult
            {
                Value = xmlDocument.GetElementsByTagName("GetDataResult")[0].InnerText
            };
        }
    }
}
