# Benefits

Poniżej wyszczególniono wymagania funkcjonalne oraz niefunkcjonalne stawiane przed aplikacją. Technologia dowolna o ile nie została określona przez wymagania.

# Kryteria oceny

* Użyta technologia
* Użyte konwencje
* Użyte wzorce projektowe
* Jakość kodu
* Liczba spełenionych wymagań

# Kontakt & Pytania

Pytania dotyczące zadania proszę kierować na adres:
 * marcin.kotula@edge1s.com 
 * adam.wojciechowski@edge1s.com

# Wymagania

**Wszystkie** wymagania *Must* muszą zostać spełnione. Przynajmniej **dwa** dowolne wymagania *Should* muszą zostać spełnione. Wymagania *Could* sa nieobowiązkowe.

## Must

* Aplikacja typu WebApi na platformie .NET
* Zaprojektuj bazę danych dla poniższych struktur danych. Pola wymagane są oznaczone gwiazdką
  * Siłownia
    * Nazwa (*)
    * Miasto (*)
    * Siłownia udostępnia trenera personalnego
    * Siłownia udostępnia saunę
    * Siłownia udostępnia dietetyka
  * Restauracja
    * Nazwa (*)
    * Miasto (*)
    * Rodzaj kuchni
    * Liczba gwiazdek
  * Użytkownik
    * Nazwa (*)
    * Data urodzenia (*)
    * Konto premium
  * Historia skorzystania z usług obiektów przez użytkowników
* API typu CRUD do zarządzania obiektami siłowni oraz restauracji
* API umożliwiające odnotowanie skorzystania z usług obiektów przez danego użytkownika
* API raportów
  * Raport zwracający zestawienie typów obiektów (Siłownia/Restauracja) wraz z liczbą wykorzystanych usług, w podziale na miasta, posortowany malejąco po najczęściej wybieranych usługach, z możliwością filtrowania po datach
  * Raport zwracający zestawienie użytkowników wraz z liczbą wykorzystanych usług, w podziale na miesiące, z możliwością filtrowania po datach

## Should

* Dokumentacja API oraz przykład wykorzystania (np w Postman)
* Klient Web konsumujący API - preferowana aplikacja SPA 
* API do wyszukiwania obiektów po dostępnych parametrach
* Skrypty wdrożeniowe / instrukcja wdrożenia
* Część obiektów wprowadza ograniczenia na skorzystanie z usług przez naszych użytkowników. Rozszerz API do korzystania z usług o dodatkowy mechanizm weryfikujący możliwość skorzystania z usługi. Reguły moga być zahardcodowane, np
  * Z obiektu mogą korzystać tylko osoby pełnoletnie
  * Z obiektu mogą korzystać tylko użytkownicy kont premium
  * Z obiektu można korzystać tylko w poniedziałki i wtorki
* Uwierzytelanianie w WebAPI
* System ról i zarządzania dostępem. Ogranicz możliwość zarządzania obiektami do określonej roli.


## Could

* W jaki sposób przygotować aplikację na dodawanie kolejnych typów obiektów
* W jaki sposób przygotować aplikację na dodawanie kolejnych parametrów obiektów
* Zaproponuj strukturę do zapisywania reguł ograniczających dostępność usług